<?php

namespace App\Filament\Pages;

use App\Models\CategoriaCorsi;
use Filament\Pages\Page;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class GestioneCategorieCorsi extends Page implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;
    use HasPageShield;

    protected static ?string $navigationGroup = 'Gestione Corsi';
    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationLabel = 'Tipologie corsi';
    protected static ?string $title = 'Gestione Categorie Corsi';
    protected static string $view = 'filament.pages.gestione-categorie-corsi';

    public ?array $data = [];

    public function mount(): void
    {
        $this->form->fill();
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('nome')
                    ->required()
                    ->maxLength(255)
                    ->unique(CategoriaCorsi::class, 'nome', ignoreRecord: true),
            ])
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();
        CategoriaCorsi::create($data);
        $this->form->fill();
        Notification::make()
            ->title('Categoria creata con successo')
            ->success()
            ->send();
    }

    public function table(Table $table): Table
    {
        return $table
            ->query(CategoriaCorsi::query())
            ->columns([
                TextColumn::make('nome')
                    ->sortable()
                    ->searchable()
                    ->limit(30)
                    ->tooltip(function (TextColumn $column): ?string {
                        $state = $column->getState();
                        
                        if (strlen($state) <= $column->getCharacterLimit()) {
                            return null;
                        }
                        
                        return $state;
                    }),
            ])
            ->filters([])
            ->actions([
                EditAction::make()
                    ->form([
                        TextInput::make('nome')
                            ->required()
                            ->maxLength(255)
                            ->unique(CategoriaCorsi::class, 'nome', ignoreRecord: true),
                    ])
                    ->using(function (CategoriaCorsi $record, array $data): CategoriaCorsi {
                        $record->update($data);
                        return $record;
                    }),
                DeleteAction::make(),
            ])
            ->bulkActions([]);
    }
}