<?php

namespace App\Filament\Resources;

use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;

class ContrattoResource
{
    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                
                Section::make('Firmatari')
                    ->schema([
                        Select::make('secondo_firmatario')
                            ->label('Secondo Firmatario')
                            ->options([
                                'xxx' => 'Dott. Mario Rossi - Xxx',
                                'direttore' => 'Dott. Massimiliano Bizzocchi - Direttore Generale',
                                'yyy' => 'Prof. Carlo Tasso - Yyy'
                            ])
                            ->required()
                            ->default('direttore')
                            ->helperText('Seleziona chi deve firmare il contratto dopo il primo firmatario'),
                    ]),
                    
            ]);
    }
} 