<?php

namespace App\Filament\Resources;

use App\Filament\Resources\FirmatarioResource\Pages;
use App\Models\Firmatario;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;

class FirmatarioResource extends Resource
{
    protected static ?string $model = Firmatario::class;
    protected static ?string $navigationIcon = 'heroicon-o-pencil-square';
    protected static ?string $navigationLabel = 'Firmatari';
    protected static ?string $modelLabel = 'Firmatario';
    protected static ?string $pluralModelLabel = 'Firmatari';
    protected static ?string $navigationGroup = 'Contratti';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Informazioni Personali')
                    ->description('Inserisci i dati personali del firmatario')
                    ->icon('heroicon-o-user')
                    ->schema([
                        Grid::make(2)
                            ->schema([
                                TextInput::make('nome')
                                    ->label('Nome')
                                    ->required()
                                    ->maxLength(255),
                                TextInput::make('cognome')
                                    ->label('Cognome')
                                    ->required()
                                    ->maxLength(255),
                            ]),
                        TextInput::make('email')
                            ->label('Email')
                            ->email()
                            ->required()
                            ->maxLength(255),
                    ]),

                Section::make('Ruolo e Titolo')
                    ->description('Specifica il ruolo e il titolo del firmatario')
                    ->icon('heroicon-o-academic-cap')
                    ->schema([
                        Grid::make(2)
                            ->schema([
                                TextInput::make('titolo')
                                    ->label('Titolo')
                                    ->required()
                                    ->maxLength(255)
                                    ->placeholder('es. Dott., Prof., Ing.'),
                                TextInput::make('ruolo')
                                    ->label('Ruolo')
                                    ->required()
                                    ->maxLength(255)
                                    ->placeholder('es. Direttore Generale, Presidente'),
                            ]),
                    ]),

                Section::make('Altre Informazioni')
                    ->description('Informazioni aggiuntive e stato del firmatario')
                    ->icon('heroicon-o-document-text')
                    ->schema([
                        Grid::make(2)
                            ->schema([
                                TextInput::make('codice')
                                    ->label('Codice')
                                    ->required()
                                    ->maxLength(255)
                                    ->placeholder('Codice identificativo'),
                                Toggle::make('attivo')
                                    ->label('Attivo')
                                    ->default(true)
                                    ->helperText('Indica se il firmatario è attualmente disponibile per la firma'),
                            ]),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('full_name')
                    ->label('Nome completo')
                    ->searchable(['nome', 'cognome'])
                    ->sortable(),
                Tables\Columns\TextColumn::make('email')
                    ->label('Email')
                    ->searchable(),
                Tables\Columns\TextColumn::make('titolo')
                    ->label('Titolo')
                    ->searchable(),
                Tables\Columns\TextColumn::make('ruolo')
                    ->label('Ruolo')
                    ->searchable(),
                Tables\Columns\TextColumn::make('codice')
                    ->label('Codice')
                    ->searchable(),
                Tables\Columns\IconColumn::make('attivo')
                    ->label('Attivo')
                    ->boolean(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Data creazione')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\TernaryFilter::make('attivo')
                    ->label('Attivo')
                    ->boolean()
                    ->trueLabel('Attivi')
                    ->falseLabel('Non attivi')
                    ->native(false),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFirmatarios::route('/'),
            'create' => Pages\CreateFirmatario::route('/create'),
            'edit' => Pages\EditFirmatario::route('/{record}/edit'),
        ];
    }
}
