<?php

namespace App\Filament\Resources\ProjectResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class PaymentsRelationManager extends RelationManager
{
    protected static string $relationship = 'payments';

    protected static ?string $title = 'Pagamenti';

    protected static ?string $modelLabel = 'Pagamento';
    
    protected static ?string $pluralModelLabel = 'Pagamenti';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\Grid::make()
                            ->schema([
                                Forms\Components\Select::make('payment_type')
                                    ->label('Tipo Pagamento')
                                    ->required()
                                    ->options([
                                        'primo_versamento' => 'I Versamento',
                                        'secondo_versamento' => 'II Versamento',
                                        'terzo_versamento' => 'III Versamento',
                                        'saldo' => 'Saldo',
                                        'altro' => 'Altro',
                                    ])
                                    ->columnSpan(1),

                                Forms\Components\DatePicker::make('payment_date')
                                    ->label('Data Pagamento')
                                    ->format('d/m/Y')
                                    ->required()
                                    ->columnSpan(1),

                                Forms\Components\TextInput::make('amount')
                                    ->label('Importo')
                                    ->required()
                                    ->numeric()
                                    ->prefix('€')
                                    ->columnSpan(1),
                            ])
                            ->columns(3),

                        Forms\Components\Textarea::make('notes')
                            ->label('Note aggiuntive')
                            ->maxLength(65535)
                            ->rows(3)
                            ->columnSpanFull()
                    ])
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('payment_type')
                    ->label('Tipo Pagamento')
                    ->formatStateUsing(fn (string $state): string => match ($state) {
                        'primo_versamento' => 'I Versamento',
                        'secondo_versamento' => 'II Versamento',
                        'terzo_versamento' => 'III Versamento',
                        'saldo' => 'Saldo',
                        'altro' => 'Altro',
                        default => $state,
                    }),
                Tables\Columns\TextColumn::make('payment_date')
                    ->label('Data Pagamento')
                    ->date('d/m/Y')
                    ->sortable(),
                Tables\Columns\TextColumn::make('amount')
                    ->label('Importo')
                    ->money('eur')
                    ->sortable(),
                Tables\Columns\TextColumn::make('notes')
                    ->label('Note')
                    ->limit(50)
                    ->wrap(),
            ])
            ->defaultSort('payment_date', 'desc')
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->label('Nuovo Pagamento'),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('Modifica'),
                Tables\Actions\DeleteAction::make()
                    ->label('Elimina'),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
} 