<?php

namespace App\Filament\Resources\ProjectResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class WorkPackagesRelationManager extends RelationManager
{
    protected static string $relationship = 'workPackages';

    protected static ?string $title = 'Work Packages';

    protected static ?string $modelLabel = 'Work Package';
    
    protected static ?string $pluralModelLabel = 'Work Packages';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\Grid::make()
                            ->schema([
                                Forms\Components\TextInput::make('code')
                                    ->label('Codice WP')
                                    ->required()
                                    ->maxLength(255)
                                    ->placeholder('es. WP1')
                                    ->columnSpan(1),

                                Forms\Components\TextInput::make('title')
                                    ->label('Titolo')
                                    ->required()
                                    ->maxLength(255)
                                    ->columnSpan(2),
                            ])
                            ->columns(2),

                        Forms\Components\Grid::make()
                            ->schema([
                                Forms\Components\DatePicker::make('start_date')
                                    ->label('Data Inizio')
                                    ->format('d/m/Y')
                                    ->columnSpan(1),

                                Forms\Components\DatePicker::make('end_date')
                                    ->label('Data Fine')
                                    ->format('d/m/Y')
                                    ->columnSpan(1),

                                Forms\Components\TextInput::make('cost_item')
                                    ->label('Voce di costo')
                                    ->maxLength(255)
                                    ->columnSpan(1),
                            ])
                            ->columns(3),

                        Forms\Components\Grid::make()
                            ->schema([
                                Forms\Components\TextInput::make('gross_amount')
                                    ->label('Importo Lordo')
                                    ->numeric()
                                    ->prefix('€')
                                    ->columnSpan(1),

                                Forms\Components\TextInput::make('reported_amount')
                                    ->label('Importo Rendicontato')
                                    ->numeric()
                                    ->prefix('€')
                                    ->columnSpan(1),

                                Forms\Components\TextInput::make('to_report_amount')
                                    ->label('Importo da Rendicontare')
                                    ->numeric()
                                    ->prefix('€')
                                    ->columnSpan(1),
                            ])
                            ->columns(3),

                        Forms\Components\Textarea::make('description')
                            ->label('Descrizione')
                            ->maxLength(65535)
                            ->rows(3)
                            ->columnSpanFull(),
                    ])
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('code')
                    ->label('Codice WP')
                    ->sortable(),
                Tables\Columns\TextColumn::make('title')
                    ->label('Titolo')
                    ->searchable()
                    ->wrap(),
                Tables\Columns\TextColumn::make('start_date')
                    ->label('Data Inizio')
                    ->date('d/m/Y'),
                Tables\Columns\TextColumn::make('end_date')
                    ->label('Data Fine')
                    ->date('d/m/Y'),
                Tables\Columns\TextColumn::make('gross_amount')
                    ->label('Importo Lordo')
                    ->money('eur')
                    ->sortable(),
                Tables\Columns\TextColumn::make('reported_amount')
                    ->label('Importo Rendicontato')
                    ->money('eur')
                    ->sortable(),
                Tables\Columns\TextColumn::make('to_report_amount')
                    ->label('Da Rendicontare')
                    ->money('eur')
                    ->sortable(),
            ])
            ->defaultSort('code')
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->label('Nuovo WP'),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('Modifica'),
                Tables\Actions\DeleteAction::make()
                    ->label('Elimina'),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
