<?php

namespace App\Filament\Widgets;

use App\Models\Anagrafica;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class AnagraficaStatsOverview extends BaseWidget
{
    protected function getStats(): array
    {
        $totaleUtenti = Anagrafica::count();
        $anagraficheComplete = Anagrafica::where('is_complete', true)->count();
        $invitiInviati = Anagrafica::whereNotNull('invited_at')->count();

        return [
            Stat::make('Totale Utenti', $totaleUtenti)
                ->description('Numero totale di utenti in anagrafica')
                ->descriptionIcon('heroicon-m-users')
                ->color('primary'),

            Stat::make('Anagrafiche Complete', $anagraficheComplete)
                ->description('Utenti con anagrafica completa')
                ->descriptionIcon('heroicon-m-check-circle')
                ->color('success'),

            Stat::make('Inviti Inviati', $invitiInviati)
                ->description('Utenti a cui è stato inviato l\'invito')
                ->descriptionIcon('heroicon-m-envelope')
                ->color('info'),
        ];
    }
}
