<?php

namespace App\Filament\Widgets;

use App\Models\Contratto;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class ContractSignersWidget extends BaseWidget
{
    protected ?string $heading = 'Statistiche Contratti';
    protected static ?int $sort = 2;
    protected int|string|array $columnSpan = 'full';
    protected static ?string $pollingInterval = '10s';

    protected function getStats(): array
    {
        return [
            Stat::make('Contratti da firmare', Contratto::whereNull('signed_at')->count())
                ->description('Contratti in attesa di firma')
                ->descriptionIcon('heroicon-m-document')
                ->color('danger'),
            Stat::make('Contratti firmati', Contratto::whereNotNull('signed_at')->count())
                ->description('Contratti completati')
                ->descriptionIcon('heroicon-m-check-badge')
                ->color('success'),
            Stat::make('Totale contratti', Contratto::count())
                ->description('Numero totale di contratti')
                ->descriptionIcon('heroicon-m-document-text')
                ->color('info'),
        ];
    }
}
