<?php

namespace App\Forms\Components;

use Filament\Forms\Components\TextInput;
use Illuminate\Support\Str;

class GooglePlacesAutocomplete extends TextInput
{
    protected string $view = 'forms.components.google-places-autocomplete';
    protected string $instanceId = '';
    protected string $addressType = '';

    public static function make(string $name): static
    {
        $static = parent::make($name);
        $static->instanceId = 'places_' . Str::random(8);
        $static->addressType = str_contains($name, 'domicilio') ? 'domicilio' : 'residenza';
        return $static;
    }

    public function getInstanceId(): string
    {
        return $this->instanceId;
    }

    public function getAddressType(): string
    {
        return $this->addressType;
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this->afterStateHydrated(function (TextInput $component, $state) {
            if (!empty($state)) {
                $component->state($state);
            }
        });

        $this->extraAttributes([
            'data-places-instance' => $this->getInstanceId(),
            'data-address-type' => $this->getAddressType(),
            'x-init' => 'if ($wire.get("data.' . $this->getName() . '")) { $el.value = $wire.get("data.' . $this->getName() . '") }',
        ]);
    }
}