<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckDownloadPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check() && (
            Auth::user()->hasRole('super_admin') ||
            Auth::user()->hasRole('segreteria_organi') ||
            Auth::user()->hasRole('manager_didattico')
        )) {
            return $next($request);
        }

        abort(403, 'Non hai i permessi per accedere a questa risorsa.');
    }
}
