<?php

namespace App\Mail;

use App\Models\Anagrafica;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class InviteToCompleteAnagrafica extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Anagrafica $anagrafica,
        public string $url
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Completa la tua anagrafica',
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.invite-complete-anagrafica',
        );
    }
}