<?php

namespace App\Mail;

use App\Models\Anagrafica;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class StaffAnagraficaCompleted extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Anagrafica $anagrafica
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Nuova anagrafica completata',
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.staff-anagrafica-completed',
            with: [
                'anagrafica' => $this->anagrafica,
            ],
        );
    }
}