<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContrattoTemplate extends Model
{
    use HasFactory;

    protected $fillable = ['nome', 'contenuto', 'is_default', 'placeholders'];

    protected $casts = [
        'is_default' => 'boolean',
        'placeholders' => 'array'
    ];

    public function contratti()
    {
        return $this->hasMany(Contratto::class, 'template_id');
    }

    public function parseContent($variables)
    {
        $content = $this->contenuto;
        
        foreach ($variables as $key => $value) {
            $content = str_replace('{{' . $key . '}}', $value, $content);
        }

        return $content;
    }
} 