<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Corso extends Model
{
    use HasFactory;

    protected $table = 'corsi';

    protected $fillable = [
        'categoria_id',
        'titolo',
        'codice',
        'anno_accademico',
        'semestre',
        'corso_di_laurea',
        'cfu',
        'durata_anni',
        'ssd',
        'presidente_cds',
        'titolo_accesso',
        'costo',
        'rateizzabile',
    ];

    public function categoria()
    {
        return $this->belongsTo(CategoriaCorsi::class, 'categoria_id');
    }
    
}
