<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ModuloPropostaCorso extends Model
{
    use HasFactory;

    protected $fillable = [
        'proposta_corso_id',
        'denominazione',
        'ssd',
        'cfu',
        'ore',
        'numero_modulo'
    ];

    public function propostaCorso(): BelongsTo
    {
        return $this->belongsTo(PropostaCorso::class);
    }

    public function figureProfessionali(): HasMany
    {
        return $this->hasMany(FiguraProfessionalePropostaCorso::class);
    }
}
