<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Provincia extends Model
{
    use HasFactory;

    protected $table = 'province';

    protected $fillable = [
        'nome',
        'abbreviazione',
        'regione',
        'capoluogo',
        'latitudine',
        'longitudine',
    ];

    public function getNomeConAbbreviazioneAttribute()
    {
        return "{$this->nome} ({$this->abbreviazione})";
    }
}
