<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class WorkPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'code',
        'title',
        'description',
        'start_date',
        'end_date',
        'cost_item',
        'gross_amount',
        'reported_amount',
        'to_report_amount',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'gross_amount' => 'decimal:2',
        'reported_amount' => 'decimal:2',
        'to_report_amount' => 'decimal:2',
    ];

    protected $appends = ['to_report_amount'];

    public function getToReportAmountAttribute(): float
    {
        $totalGross = $this->budgetItems()->sum('gross_amount');
        return $this->gross_amount - $totalGross;
    }

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function budgetItems(): HasMany
    {
        return $this->hasMany(BudgetItem::class);
    }

}
