<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PanelAccessCredentials extends Notification implements ShouldQueue
{
    use Queueable;

    protected $password;
    protected $name;

    public function __construct($name, $password)
    {
        $this->password = $password;
        $this->name = $name;
    }

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Accesso al Pannello IULConnect')
            ->greeting("Ciao {$this->name},")
            ->line('Ti sono state create le credenziali di accesso al pannello IULConnect.')
            ->line('Di seguito trovi le tue credenziali:')
            ->line("Email: {$notifiable->email}")
            ->line("Password temporanea: {$this->password}")
            ->line('Ti consigliamo di cambiare la password al primo accesso.')
            ->action('Accedi al Pannello', url('/admin'))
            ->line('Grazie per l\'utilizzo della nostra applicazione!');
    }
}
