<?php

namespace App\Providers\Filament;

use App\Filament\Pages\ResetPassword;
use App\Filament\Widgets\AnagraficaStatsOverview;
use App\Filament\Widgets\AnagraficaRegistrationChart;
use App\Filament\Widgets\AnagraficaCompletionChart;
use App\Filament\Widgets\CalendarWidget;
use App\Filament\Widgets\ContractSignersWidget;
use App\Filament\Widgets\ContrattiRecenti;
use App\Http\Middleware\FirstAccessPasswordReset;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use pxlrbt\FilamentSpotlight\SpotlightPlugin;
use Filament\Support\Enums\MaxWidth;
use Filament\View\PanelsRenderHook;
use Saade\FilamentFullCalendar\FilamentFullCalendarPlugin;
use Filament\Pages;
use Illuminate\Support\Facades\Auth;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->brandLogo(asset('assets/loghi/logo-iul2.png'))
            ->brandLogoHeight('3rem')
            ->login()
            ->colors([
                'primary' => Color::Blue,
            ])
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([
                ResetPassword::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([
                ContractSignersWidget::class,
                ContrattiRecenti::class,
                AnagraficaStatsOverview::class,
                AnagraficaRegistrationChart::class,
                AnagraficaCompletionChart::class,
                CalendarWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
                FirstAccessPasswordReset::class,
            ])
            ->plugins([
                SpotlightPlugin::make(),
                \BezhanSalleh\FilamentShield\FilamentShieldPlugin::make(),
                FilamentFullCalendarPlugin::make()
                    ->selectable()
                    ->editable()
                    ->plugins(['interaction', 'dayGrid', 'timeGrid', 'list', 'multiMonth']),
            ])
            ->maxContentWidth(MaxWidth::Full)
            ->darkMode(false)
            ->viteTheme('resources/css/filament/admin/theme.css')
            ->authMiddleware([
                Authenticate::class,
            ]);
    }
}
