<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        // Mappa le vecchie tipologie alle nuove
        $mappingTipologie = [
            'Docente' => 'personale-strutturato',
            'Dipendente' => 'personale-tecnico-amministrativo',
            'Collaboratore' => 'collaboratori-occasionali',
            'Studente' => 'collaboratori-occasionali',
            'Fornitore' => 'consulenti-p-iva',
            'Altro' => 'collaboratori-occasionali'
        ];

        if (Schema::hasTable('anagrafiche')) {
            // Aggiorna i record esistenti
            foreach ($mappingTipologie as $vecchia => $nuova) {
                DB::table('anagrafiche')
                    ->where('tipologia_utente', $vecchia)
                    ->update(['tipologia_utente' => $nuova]);
            }

            // Modifica la colonna tipologia_utente nella tabella anagrafiche
            Schema::table('anagrafiche', function (Blueprint $table) {
                // Controlla se la foreign key esiste prima di rimuoverla
                $foreignKeys = DB::select("
                    SELECT CONSTRAINT_NAME
                    FROM information_schema.TABLE_CONSTRAINTS
                    WHERE CONSTRAINT_SCHEMA = DATABASE()
                    AND TABLE_NAME = 'anagrafiche'
                    AND CONSTRAINT_TYPE = 'FOREIGN KEY'
                    AND CONSTRAINT_NAME = 'anagrafiche_tipologia_utente_foreign'
                ");

                if (!empty($foreignKeys)) {
                    $table->dropForeign(['tipologia_utente']);
                }
                
                // Aggiorna la colonna
                $table->string('tipologia_utente')->nullable()->change();
                
                // Aggiungi la nuova foreign key
                $table->foreign('tipologia_utente')
                    ->references('slug')
                    ->on('tipologie_utente')
                    ->nullOnDelete();
            });
        }
    }

    public function down()
    {
        if (Schema::hasTable('anagrafiche')) {
            Schema::table('anagrafiche', function (Blueprint $table) {
                // Controlla se la foreign key esiste prima di rimuoverla
                $foreignKeys = DB::select("
                    SELECT CONSTRAINT_NAME
                    FROM information_schema.TABLE_CONSTRAINTS
                    WHERE CONSTRAINT_SCHEMA = DATABASE()
                    AND TABLE_NAME = 'anagrafiche'
                    AND CONSTRAINT_TYPE = 'FOREIGN KEY'
                    AND CONSTRAINT_NAME = 'anagrafiche_tipologia_utente_foreign'
                ");

                if (!empty($foreignKeys)) {
                    $table->dropForeign(['tipologia_utente']);
                }
            });
        }
    }
}; 