<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('anagrafiche', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('cognome');
            $table->string('telefono')->nullable();
            $table->string('email')->unique();
            $table->string('codice_fiscale')->unique();
            $table->date('data_nascita');
            $table->string('citta_nascita');
            $table->string('provincia_nascita', 2);
            $table->string('indirizzo_residenza');
            $table->string('numero_civico_residenza');
            $table->string('cap_residenza', 5);
            $table->string('citta_residenza');
            $table->string('provincia_residenza', 2);
            $table->boolean('ha_domicilio_diverso')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('anagrafiche');
    }
};
