<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('contratti', function (Blueprint $table) {
            if (!Schema::hasColumn('contratti', 'tipo_contratto_id')) {
                $table->unsignedBigInteger('tipo_contratto_id')->nullable()->after('anagrafica_id');
            }
            
            $table->foreign('tipo_contratto_id')
            ->references('id')
            ->on('tipi_contratto')
            ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropForeign(['tipo_contratto_id']);
            $table->dropColumn('tipo_contratto_id');
        });
    }
};