<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            // Dati fiscali
            $table->string('tipologia_lavoro')->nullable();
            $table->string('partita_iva')->nullable();
            $table->string('albo_professionale')->nullable();
            $table->string('cassa_previdenziale')->nullable();
            $table->string('aliquota_inps')->nullable();
            
            // Dati PA
            $table->boolean('is_dipendente_pa')->default(false);
            $table->string('pa_denominazione')->nullable();
            $table->string('pa_autorizzazione_numero')->nullable();
            $table->date('pa_autorizzazione_data')->nullable();
            
            // Altri dati
            $table->boolean('is_pensionato')->default(false);
            
            // Dati pagamento
            $table->string('iban')->nullable();
        });
    }

    public function down()
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->dropColumn([
                'tipologia_lavoro',
                'partita_iva',
                'albo_professionale', 
                'cassa_previdenziale',
                'aliquota_inps',
                'is_dipendente_pa',
                'pa_denominazione',
                'pa_autorizzazione_numero',
                'pa_autorizzazione_data',
                'is_pensionato',
                'iban'
            ]);
        });
    }
}; 