<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->boolean('is_dipendente_pa_rapporto')->default(false);
            $table->string('pa_denominazione_rapporto')->nullable();
            $table->string('pa_esclusione_tipo')->nullable();
            $table->text('pa_esclusione_dettagli')->nullable();
            $table->string('pa_autorizzazione_numero_rapporto')->nullable();
            $table->date('pa_autorizzazione_data_rapporto')->nullable();
            $table->boolean('is_pensionato_diretto')->default(false);
            $table->boolean('is_senza_previdenza')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->dropColumn([
                'is_dipendente_pa_rapporto',
                'pa_denominazione_rapporto',
                'pa_esclusione_tipo',
                'pa_esclusione_dettagli',
                'pa_autorizzazione_numero_rapporto',
                'pa_autorizzazione_data_rapporto',
                'is_pensionato_diretto',
                'is_senza_previdenza'
            ]);
        });
    }
};
