<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Anagrafica;
use App\Models\WorkPackage;
use App\Models\Project;
use App\Models\BudgetItem;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('anagrafiche_project', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Anagrafica::class)->onDelete('cascade');
            $table->foreignIdFor(Project::class)->onDelete('cascade');
            $table->foreignIdFor(WorkPackage::class)->onDelete('cascade');
            $table->foreignIdFor(BudgetItem::class)->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('anagrafiche_project');
    }
};
