<?php

namespace Database\Seeders;

use App\Models\BudgetCategory;
use App\Models\BudgetSubcategory;
use Illuminate\Database\Seeder;

class BudgetCategoriesSeeder extends Seeder
{
    public function run(): void
    {
        // Personale Interno
        $personale = BudgetCategory::create([
            'name' => 'Personale',
            'description' => 'Costi relativi al personale',
        ]);

        // Personale esterno assunto ad hoc
        //$personaleEsterno = BudgetCategory::create([
        //    'name' => 'Personale esterno assunto ad hoc',
        //    'description' => 'Costi relativi al personale esterno assunto ad hoc',
        //]);

        // Strumenti e attrezzature
        $strumenti = BudgetCategory::create([
            'name' => 'Strumenti e attrezzature',
            'description' => 'Costi relativi a strumenti e attrezzature',
        ]);

        // Sottocategorie per Strumenti e attrezzature
        $ammortamenti = [
            ['name' => 'Ammortamenti immobilizzazioni immateriali', 'code' => 'B-X-001-1-1'],
            ['name' => 'Svalutazioni immobilizzazioni finanziarie', 'code' => 'B-X-001-1-2'],
            ['name' => 'Svalutazioni attività finanziarie non immobilizzazioni', 'code' => 'B-X-001-1-3'],
        ];

        foreach ($ammortamenti as $item) {
            BudgetSubcategory::create([
                'budget_category_id' => $strumenti->id,
                'name' => $item['name'],
                'code' => $item['code'],
            ]);
        }

        $costiGodimento = [
            ['name' => 'Noleggi e spese accessorie', 'code' => 'B-IX-11-1-1'],
            ['name' => 'Canoni Leasing finanziario', 'code' => 'B-IX-11-1-2'],
            ['name' => 'Altri oneri per godimento beni di terzi', 'code' => 'B-IX-11-1-3'],
            ['name' => 'Leasing operativo ed altre Nome di locazione di beni mobili', 'code' => 'B-IX-11-1-4'],
            ['name' => 'Licenze software', 'code' => 'B-IX-11-1-5'],
        ];

        foreach ($costiGodimento as $item) {
            BudgetSubcategory::create([
                'budget_category_id' => $strumenti->id,
                'name' => $item['name'],
                'code' => $item['code'],
            ]);
        }

        // Consulenze /subcontraenze esterne
        $consulenze = BudgetCategory::create([
            'name' => 'Consulenze /subcontraenze esterne',
            'description' => 'Costi relativi a consulenze e subcontraenze esterne',
        ]);

        $servizi = [
            ['name' => 'Utenze e canoni', 'code' => 'B-IX-8-01-1'],
            ['name' => 'Pulizia', 'code' => 'B-IX-8-01-2'],
            ['name' => 'Riscaldamento, servizi termici e condizionamento', 'code' => 'B-IX-8-01-3'],
            ['name' => 'Vigilanza', 'code' => 'B-IX-8-01-4'],
            ['name' => 'Servizi global service', 'code' => 'B-IX-8-01-5'],
            ['name' => 'Servizi manutenzione beni materiali e immateriali', 'code' => 'B-IX-8-01-6'],
            ['name' => 'Servizi di mensa in appalto', 'code' => 'B-IX-8-01-7'],
            ['name' => 'Servizi per alloggi studenti e foresteria', 'code' => 'B-IX-8-01-8'],
            ['name' => 'Spese per trasporto studenti', 'code' => 'B-IX-8-01-9'],
            ['name' => 'Spese per trasporti, traslochi e facchinaggio', 'code' => 'B-IX-8-1-10'],
            ['name' => 'Consulenze gestionali', 'code' => 'B-IX-8-1-11'],
            ['name' => 'Consulenze tecnico-informatiche', 'code' => 'B-IX-8-1-12'],
            ['name' => 'Prestazioni di servizi pubblicitari, di promozione e di divulgazione', 'code' => 'B-IX-8-1-13'],
            ['name' => 'Prestazioni di servizi di organizzazione congressi, convegni, seminari e manifestazioni', 'code' => 'B-IX-8-1-14'],
            ['name' => 'Servizi per spese di rappresentanza', 'code' => 'B-IX-8-1-15'],
            ['name' => 'Spese per liti (patrocinio legale)', 'code' => 'B-IX-8-1-16'],
            ['name' => 'Smaltimento rifiuti nocivi', 'code' => 'B-IX-8-1-17'],
        ];

        foreach ($servizi as $item) {
            BudgetSubcategory::create([
                'budget_category_id' => $consulenze->id,
                'name' => $item['name'],
                'code' => $item['code'],
            ]);
        }

        // Viaggi/accomodation
        $viaggi = BudgetCategory::create([
            'name' => 'Viaggi/accomodation',
            'description' => 'Costi relativi a viaggi e accomodation',
        ]);

        // Altri Costi
        $altriCosti = BudgetCategory::create([
            'name' => 'Altri Costi',
            'description' => 'Altri costi vari',
        ]);

        $materialiConsumo = [
            ['name' => 'Conti per acquisto materiali consumo per laboratori didattica e ricerca', 'code' => 'B-IX-5-01-1'],
            ['name' => 'Conti relativi all\'acquisto di libri periodici e materiale bibliografico', 'code' => 'B-IX-7-01-1'],
        ];

        foreach ($materialiConsumo as $item) {
            BudgetSubcategory::create([
                'budget_category_id' => $altriCosti->id,
                'name' => $item['name'],
                'code' => $item['code'],
            ]);
        }

        $personaleRicercaDidattica = [
            //Docenti e Ricercatori
            ['name' => 'Docente/Ricercatore - Competenze fisse', 'code' => 'B-VII-1-A-1'],
            ['name' => 'Docente/Ricercatore - Competenze per supplenze personale docente docente/ricercatore', 'code' => 'B-VII-1-A-2'],
            ['name' => 'Docente/Ricercatore - Compensi per attivit&agrave; commerciale al personale docente/ricercatore', 'code' => 'B-VII-1-A-3'],
            ['name' => 'Docente/Ricercatore - Competenze per indennit&agrave; di rischio al personale docente/ricercatore', 'code' => 'B-VII-1-A-4'],
            ['name' => 'Docente/Ricercatore - Premialit&agrave; personale docente/ricercatore', 'code' => 'B-VII-1-A-5'],
            ['name' => 'Docente/Ricercatore - Altre competenze accessorie al personale docente/ricercatore', 'code' => 'B-VII-1-A-6'],
            ['name' => 'Docente/Ricercatore - Contributi obbligatori a carico Ente per il personale (esclusa IRAP)', 'code' => 'B-VII-1-A-7'],

            //Collaborazioni Scientifiche
            ['name' => 'Collaborazioni scientifiche (collaboratori, assegnisti, ecc.) - Costi per assegnisti, collaborazioni, ecc.', 'code' => 'B-VII-1-B-1'],
            ['name' => 'Collaborazioni scientifiche (collaboratori, assegnisti, ecc.) - Assegni di Ricerca', 'code' => 'B-VII-1-B-2'],
            ['name' => 'Collaborazioni scientifiche (collaboratori, assegnisti, ecc.) - Collaborazioni coordinate e continuative scientifiche', 'code' => 'B-VII-1-B-3'],
            ['name' => 'Collaborazioni scientifiche (collaboratori, assegnisti, ecc.) - Collaborazioni esterne scientifiche di tipo occasionale', 'code' => 'B-VII-1-B-4'],
            ['name' => 'Collaborazioni scientifiche (collaboratori, assegnisti, ecc.) - Contributi obbligatori a carico Ente per il personale (esclusa IRAP)', 'code' => 'B-VII-1-B-5'],

            //Docenti a contratto
            ['name' => 'Docenti a contratto - Costi per docenti a contratto', 'code' => 'B-VII-1-C-1'],
            ['name' => 'Docenti a contratto - Docenti a contratto', 'code' => 'B-VII-1-C-2'],
            ['name' => 'Docenti a contratto - Incarichi insegnamento docenti altri atenei', 'code' => 'B-VII-1-C-3'],
            ['name' => 'Docenti a contratto - Contratti per attivit&agrave; di supporto alla didattica', 'code' => 'B-VII-1-C-4'],
            ['name' => 'Docenti a contratto - Contributi obbligatori a carico Ente per il personale (esclusa IRAP)', 'code' => 'B-VII-1-C-5'],

            //Esperti Linguistici
            ['name' => 'Esperti linguistici - Costi per esperti linguistici', 'code' => 'B-VII-1-D-1'],
            ['name' => 'Esperti linguistici - Esperti linguistici a tempo indeterminato', 'code' => 'B-VII-1-D-2'],
            ['name' => 'Esperti linguistici - Esperti linguistici a tempo determinato', 'code' => 'B-VII-1-D-3'],
            ['name' => 'Esperti linguistici - Indennit&agrave; TFR esperti linguistici', 'code' => 'B-VII-1-D-4'],
            ['name' => 'Esperti linguistici - Contributi obbligatori a carico Ente per il personale (esclusa IRAP)', 'code' => 'B-VII-1-D-5'],

            //Altro personale dedito alla didattica e alla ricerca
            ['name' => 'Altro personale dedito alla didattica e alla ricerca - Costi per altro personale dedito alla didattica e alla ricerca', 'code' => 'B-VII-1-E-1'],
            ['name' => 'Altro personale dedito alla didattica e alla ricerca - Altre collaborazioni per ricerca e didattica', 'code' => 'B-VII-1-E-2'],
            ['name' => 'Altro personale dedito alla didattica e alla ricerca - Visiting professor', 'code' => 'B-VII-1-E-3'],
            ['name' => 'Altro personale dedito alla didattica e alla ricerca - Operai Agricoli Stagionali', 'code' => 'B-VII-1-E-4'],
            ['name' => 'Altro personale dedito alla didattica e alla ricerca - Indennit&agrave; TFR', 'code' => 'B-VII-1-E-5'],
            ['name' => 'Altro personale dedito alla didattica e alla ricerca - Contributi obbligatori a carico Ente per il personale (esclusa IRAP)', 'code' => 'B-VII-1-E-6'],
        ];

        foreach ($personaleRicercaDidattica as $item) {
            BudgetSubcategory::create([
                'budget_category_id' => $personale->id,
                'name' => $item['name'],
                'code' => $item['code'],
            ]);
        }

        $personaleDirigenteAmministrativo = [
            ['name' => 'Personale dirigente e tecnico-amministrativo - Competenze fisse', 'code' => 'B-VII-2-1-1'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Competenze per attivit&agrave commerciale, indennit&agrave di rischio, premialita&agrave;, buoni pasto, altre competenze accessorie', 'code' => 'B-VII-2-1-2'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Compensi per attivit&agrave; commerciale al personale dirigente e tecnico-amministrativo', 'code' => 'B-VII-2-1-3'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Altre competenze accessorie personale dirigente e tecnico-amministrativo', 'code' => 'B-VII-2-1-4'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Indennit&agrave; TFR', 'code' => 'B-VII-2-1-5'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Indennit&agrave; TFR personale dirigente e PTA', 'code' => 'B-VII-2-1-6'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Costi per buoni pasto', 'code' => 'B-VII-2-1-7'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Oneri previdenza integrativa', 'code' => 'B-VII-2-1-8'],
            ['name' => 'Personale dirigente e tecnico-amministrativo - Contributi obbligatori a carico Ente per il personale (esclusa IRAP)', 'code' => 'B-VII-2-1-9'],
        ];

        foreach ($personaleDirigenteAmministrativo as $item) {
            BudgetSubcategory::create([
                'budget_category_id' => $personale->id,
                'name' => $item['name'],
                'code' => $item['code'],
            ]);
        }
    }
} 
