<?php

namespace Database\Seeders;

use App\Models\Corso;
use App\Models\CategoriaCorsi;
use Illuminate\Database\Seeder;

class CorsiSingoliSeeder extends Seeder
{
    public function run()
    {
        $categoriaId = CategoriaCorsi::where('nome', 'CORSI SINGOLI')->first()->id;

        $corsi = [
            [
                'titolo' => 'Processi psicologici per lo sviluppo infantile',
                'ssd' => 'M-PSI/04',
                'anno_accademico' => '2023/2024',
                'semestre' => 'III ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Psicologia clinica e prima infanzia',
                'ssd' => 'M-PSI/08',
                'anno_accademico' => '2023/2024',
                'semestre' => 'III ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],

            [
                'titolo' => 'Diritto dei diritti dell\'Infanzia',
                'ssd' => 'IUS/17',
                'anno_accademico' => '2023/2024',
                'semestre' => 'ANNO III; SEMESTRE 2',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Metodologie educative per l\'infanzia',
                'ssd' => 'M-PED/03',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Fondamenti di psicologia dall\'infanzia all\'età adulta',
                'ssd' => 'M-PSI/01',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Letteratura italiana',
                'ssd' => 'L-FIL-LET/11',
                'anno_accademico' => '2022/2023',
                'semestre' => 'III ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Attività sperimentali per la prima infanzia',
                'ssd' => 'M-PED/04',
                'anno_accademico' => '2022/2023',
                'semestre' => 'II ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Informatica e tecnologie della comunicazione digitale',
                'ssd' => 'INF/01',
                'anno_accademico' => '2022/2023',
                'semestre' => 'I ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Tecniche e strategie di comunicazione per il marketing',
                'ssd' => 'SECS-P/08',
                'anno_accademico' => '2022/2023',
                'semestre' => 'III ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Storia politica sociale e culturale dell\'età contemporanea',
                'ssd' => 'M-STO/04',
                'anno_accademico' => '2022/2023',
                'semestre' => 'I ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Semiotica del branding e della pubblicità',
                'ssd' => 'M-FIL/05',
                'anno_accademico' => '2022/2023',
                'semestre' => 'III ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Nuovi media nei contesti di apprendimento',
                'ssd' => 'M-PED/04',
                'anno_accademico' => '2022/2023',
                'semestre' => 'I ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Metodi di ricerca per la comunicazione',
                'ssd' => 'SPS/08',
                'anno_accademico' => '2022/2023',
                'semestre' => 'II ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Laboratorio di tecniche di scrittura e linguaggi del giornalismo',
                'ssd' => 'L-LIN/01',
                'anno_accademico' => '2022/2023',
                'semestre' => 'I SEMESTRE; II ANNO',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Laboratorio Informatico',
                'ssd' => null,
                'anno_accademico' => '2022/2023',
                'semestre' => 'I ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Filosofia e scienza politica',
                'ssd' => 'SPS/01',
                'anno_accademico' => '2022/2023',
                'semestre' => 'II ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Diritto e proprietà intellettuale nella società dell\'informazione',
                'ssd' => 'IUS/04',
                'anno_accademico' => '2022/2023',
                'semestre' => 'III ANNO; I SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Comunicazione verbale e linguaggio dei media',
                'ssd' => 'L-LIN/01',
                'anno_accademico' => '2022/2023',
                'semestre' => 'I SEMESTRE; I ANNO',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Editing Multimediale',
                'ssd' => 'INF/01',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 12,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Laboratorio di informatica',
                'ssd' => null,
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Teorie e tecniche della comunicazione per l\'infanzia',
                'ssd' => 'SPS/08',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 12,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Pedagogia delle attività ludico-motorie per l\'infanzia',
                'ssd' => 'M-PED/01',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze e tecniche dell\'educazione e dei servizi per l\'infanzia, classe L-19',
                'cfu' => 12,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Psicologia Sociale',
                'ssd' => 'M-PSI/05',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese, classe L-24',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Geografia politica ed economia internazionale',
                'ssd' => 'M-GGR/02',
                'anno_accademico' => '2022/2023',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Economia e gestione delle imprese',
                'ssd' => 'SECS-P/08',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Politica economica',
                'ssd' => 'SECS-P/02',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO - II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Economia Applicata: Industrie, Mercati, Regioni',
                'ssd' => 'SECS-P/06',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Economia degli intermediari finanziari',
                'ssd' => 'SECS-P/11',
                'anno_accademico' => '2023/2024',
                'semestre' => 'III ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Laboratorio Applicato di Sostenibilità ed ESG',
                'ssd' => null,
                'anno_accademico' => '2023/2024',
                'semestre' => 'III ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 3,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Dinamiche della popolazione',
                'ssd' => 'SECS-S/04',
                'anno_accademico' => '2023/2024',
                'semestre' => 'III ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Laboratorio applicato (altre conoscenze utili per il mondo del lavoro)',
                'ssd' => null,
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 3,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Lingua inglese',
                'ssd' => 'L-LIN/12',
                'anno_accademico' => '2022/2023',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Organizzazione Industriale: teoria e regolamentazione',
                'ssd' => 'SECS-P/02',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Istituzioni di Economia',
                'ssd' => 'SECS/P01',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Economia, management e mercati internazionali, classe L-33',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Laboratorio di Lingua Inglese',
                'ssd' => null,
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Fondamenti di scienze sociali',
                'ssd' => 'SPS/07',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Storia politica sociale e culturale dell\'età contemporanea',
                'ssd' => 'M-STO/04',
                'anno_accademico' => '2023/2024',
                'semestre' => 'I ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Nuovi media nei contesti di apprendimento',
                'ssd' => 'M-PED/04',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Tecnologie della comunicazione per il web',
                'ssd' => 'ING-INF/05',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Sociologia degli ecosistemi',
                'ssd' => 'SPS/10',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Estetica dei linguaggi audiovisivi',
                'ssd' => 'L-ART/06',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Comunicazione innovativa, multimediale e digitale, classe L-20',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Economia e gestione delle imprese',
                'ssd' => 'SECS-P/08',
                'anno_accademico' => '2022/2023',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese, classe L-24',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Didattica e inclusione',
                'ssd' => 'M-PED/03',
                'anno_accademico' => '2023/2024',
                'semestre' => 'III ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese, classe L-24',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Psicologia della personalità e delle differenze individuali',
                'ssd' => 'M-PSI/01',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese, classe L-24',
                'cfu' => 6,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Psicologia dei Gruppi, Management e Leadership',
                'ssd' => 'M-PSI/05',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO - I SEMESTRE',
                'corso_di_laurea' => 'Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese, classe L-24',
                'cfu' => 9,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
            [
                'titolo' => 'Metodologia della ricerca azione. Colloquio clinico e intervista nei contesti organizzativi',
                'ssd' => 'M-PSI/06',
                'anno_accademico' => '2023/2024',
                'semestre' => 'II ANNO; II SEMESTRE',
                'corso_di_laurea' => 'Scienze psicologiche delle risorse umane, delle organizzazioni e delle imprese, classe L-24',
                'cfu' => 12,
                'categoria_id' => $categoriaId,
                'costo' => 0,
            ],
        ];

        foreach ($corsi as $corso) {
            Corso::create($corso);
        }
    }
} 