<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Project;
use App\Models\FundingBody;

class ProjectsSeeder extends Seeder
{
    public function run(): void
    {
        $projects = [
            [
                'title' => 'AIDI - AI PER L\'APPRENDIMENTO IN ITALIANO E IL DIALOGO IN ITALIANO',
                'funding_bodies' => ['Università per Stranieri di Perugia'],
            ],
            [
                'title' => 'APP(IU\'L): comunicazione digitale etica ed efficace',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Approccio outside-in e customer experience per un nuovo modello di agenzia di comunicazione',
                'funding_bodies' => ['NEISOS, Arkage'],
            ],
            [
                'title' => 'Classi in rete. Sperimentazione di una formula di "lezione condivisa" nelle piccole scuole abruzzesi',
                'funding_bodies' => ['INDIRE'],
            ],
            [
                'title' => 'CLIL for STEAM',
                'funding_bodies' => ['Erasmus+ Programme'],
            ],
            [
                'title' => 'CO2 Footprint Authentication Module (COFAM)',
                'funding_bodies' => ['Avviso Fondo per la Crescita Sostenibile'],
            ],
            [
                'title' => 'Critical Thinking to Improve Problem Solving. PATHS for Business Companies',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'DICE - Digital Community Engagement Accelerator',
                'funding_bodies' => ['Agenzia Nazionale Erasmus + Slovacchia'],
            ],
            [
                'title' => 'DIGITAL INPUT',
                'funding_bodies' => ['Fondo per la Repubblica Digitale -- Impresa Sociale S.r.l.'],
            ],
            [
                'title' => 'DopOff - Sport e disabilità fisica',
                'funding_bodies' => ['Ministero della Salute - DG Prevenzione sanitaria'],
            ],
            [
                'title' => 'E-VOTA: il voto elettronico con riconoscimento utente',
                'funding_bodies' => ['Atomtech s.r.l'],
            ],
            [
                'title' => 'EDUREFORM',
                'funding_bodies' => ['European Commission'],
            ],
            [
                'title' => 'ELEGANTS',
                'funding_bodies' => ['Commissione Europea'],
            ],
            [
                'title' => 'Escape room come strategia educativa',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'EXCALIBUR',
                'funding_bodies' => ['Erasmus+ Programme'],
            ],
            [
                'title' => 'FAMILY CAREGIVER SUPPORT',
                'funding_bodies' => ['European Commission'],
            ],
            [
                'title' => 'Gamification e Serious Game',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'GEASA: Upgrading Global Education',
                'funding_bodies' => ['Erasmus+ Programme'],
            ],
            [
                'title' => 'GUINEVERE',
                'funding_bodies' => ['European Commission'],
            ],
            [
                'title' => 'I comportamenti naturali applicati alla Realtà Virtuale',
                'funding_bodies' => ['LYNK INTERNATIONAL S.r.l'],
            ],
            [
                'title' => 'I-PATHS',
                'funding_bodies' => ['Erasmus+ Programme'],
            ],
            [
                'title' => 'ICIPES - International Covid 19 Impact',
                'funding_bodies' => ['University of Bath'],
            ],
            [
                'title' => 'Il ruolo delle attività motorie',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'IL VALORE E L\'UTILIZZO DEI GIOCHI DA TAVOLO',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'IWDPD - Innovation in Window and Door Profile Designs',
                'funding_bodies' => ['Serramenti Falchetti Srl'],
            ],
            [
                'title' => 'La crisi dei sistemi scolastici',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'La didattica collaborativa online',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'La fiducia in gioco',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'L\'e-tutoring nella didattica telematica',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Leadership Condivisa per il Cambiamento',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'L\'inclusione sociale attraverso lo sport',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Lingua italiana, mercato globale',
                'funding_bodies' => ['Università per Stranieri di Siena'],
            ],
            [
                'title' => 'MICRAG - How "micro" can aggression be?',
                'funding_bodies' => ['European Commission'],
            ],
            [
                'title' => 'Network Scuola e Sport',
                'funding_bodies' => ['INDIRE'],
            ],
            [
                'title' => 'Neuroscienze per la continuità didattica',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Optimizing Distance Learning Educational Programs',
                'funding_bodies' => ['Erasmus+ Programme'],
            ],
            [
                'title' => 'Parole in movimento per una didattica integrata',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Percorsi di sviluppo nella carriera docente',
                'funding_bodies' => ['Università degli studi di Bologna'],
            ],
            [
                'title' => 'Philosophy for Children e Virtue Epistemology',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'POLIMNIA, OPERA PER TUTTI!',
                'funding_bodies' => ['Ministero dell\'Università e della Ricerca'],
            ],
            [
                'title' => 'Pratiche di insegnamento-apprendimento della filosofia',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Promuovere il successo formativo degli studenti',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'PROTECT',
                'funding_bodies' => ['Camara Oficial de Comercio e Industria de Badajoz'],
            ],
            [
                'title' => 'Qualità e partecipazione in Ateneo',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'RIME. Raccontare il Territorio',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'SEARCH - Sport Education',
                'funding_bodies' => ['ECC Verein fur interdisziplinaere Bildung und Beratung'],
            ],
            [
                'title' => 'Social learning e attività interattive online',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'STEAM-IT',
                'funding_bodies' => ['INDIRE'],
            ],
            [
                'title' => 'Strategie e strumenti di gamification',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'Superare le sfide dell\'Università',
                'funding_bodies' => ['Università Telematica degli Studi IUL'],
            ],
            [
                'title' => 'SUPPORT',
                'funding_bodies' => ['Ministero dell\'Università e della Ricerca'],
            ],
            [
                'title' => 'Trasparenza nel mercato Internet Media',
                'funding_bodies' => ['NEISOS, Arkage'],
            ],
            [
                'title' => 'WORK FROM BED',
                'funding_bodies' => ['Fondo per la Repubblica Digitale Impresa sociale'],
            ],
        ];

        foreach ($projects as $projectData) {
            $fundingBodiesNames = $projectData['funding_bodies'];
            unset($projectData['funding_bodies']);
            
            $project = Project::create($projectData);
            
            $fundingBodies = FundingBody::whereIn('name', $fundingBodiesNames)->get();
            $project->fundingBodies()->attach($fundingBodies->pluck('id'));
        }
    }
} 