<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use BezhanSalleh\FilamentShield\Support\Utils;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class ShieldSeeder extends Seeder
{
    public function run(): void
    {
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $rolesWithPermissions = '[
            {
                "name": "super_admin",
                "guard_name": "web",
                "permissions": [
                    "page_UserDashboard",
                    "page_Anagrafica",
                    "page_CreateAnagrafica",
                    "page_Calendario",
                    "page_CreateContratti",
                    "page_GestioneCategorieCorsi",
                    "page_GestioneContatti",
                    "page_GestioneContratti",
                    "page_GestioneCorsi",
                    "page_SupabaseConversations",
                    "widget_AnagraficaCompletionChart",
                    "widget_AnagraficaRegistrationChart",
                    "widget_AnagraficaStatsOverview",
                    "widget_CalendarWidget",
                    "widget_ContractSignersWidget",
                    "widget_ContrattiRecenti",
                    "view_role",
                    "view_any_role",
                    "create_role",
                    "update_role",
                    "delete_role",
                    "delete_any_role",
                    "view_user",
                    "view_any_user",
                    "create_user",
                    "update_user",
                    "restore_user",
                    "restore_any_user",
                    "replicate_user",
                    "reorder_user",
                    "delete_user",
                    "delete_any_user",
                    "force_delete_user",
                    "force_delete_any_user",
                    "view_firmatario",
                    "view_any_firmatario",
                    "create_firmatario",
                    "update_firmatario",
                    "restore_firmatario",
                    "restore_any_firmatario",
                    "replicate_firmatario",
                    "reorder_firmatario",
                    "delete_firmatario",
                    "delete_any_firmatario",
                    "force_delete_firmatario",
                    "force_delete_any_firmatario",
                    "view_funding::body",
                    "view_any_funding::body",
                    "create_funding::body",
                    "update_funding::body",
                    "delete_funding::body",
                    "delete_any_funding::body",
                    "view_project",
                    "view_any_project",
                    "create_project",
                    "update_project",
                    "delete_project",
                    "delete_any_project",
                    "restore_project",
                    "restore_any_project",
                    "replicate_project",
                    "reorder_project",
                    "force_delete_project",
                    "force_delete_any_project",
                    "view_budget::category",
                    "view_any_budget::category",
                    "create_budget::category",
                    "update_budget::category",
                    "delete_budget::category",
                    "delete_any_budget::category",
                    "view_budget::subcategory",
                    "view_any_budget::subcategory",
                    "create_budget::subcategory",
                    "update_budget::subcategory",
                    "delete_budget::subcategory",
                    "delete_any_budget::subcategory",
                    "view_budget::item",
                    "view_any_budget::item",
                    "create_budget::item",
                    "update_budget::item",
                    "delete_budget::item",
                    "delete_any_budget::item",
                    "view_corso",
                    "view_any_corso",
                    "create_corso",
                    "update_corso",
                    "delete_corso",
                    "delete_any_corso",
                    "view_candidature",
                    "view_any_candidature",
                    "create_candidature",
                    "update_candidature",
                    "delete_candidature"
                ]
            },
            {
                "name": "Staff IUL",
                "guard_name": "web",
                "permissions": [
                    "page_UserDashboard",
                    "page_Anagrafica",
                    "page_CreateAnagrafica",
                    "page_Calendario",
                    "page_CreateContratti",
                    "page_GestioneCategorieCorsi",
                    "page_GestioneContatti",
                    "page_GestioneContratti",
                    "page_GestioneCorsi",
                    "widget_AnagraficaCompletionChart",
                    "widget_AnagraficaRegistrationChart",
                    "widget_AnagraficaStatsOverview",
                    "widget_CalendarWidget",
                    "widget_ContractSignersWidget",
                    "widget_ContrattiRecenti",
                    "view_firmatario",
                    "view_any_firmatario",
                    "create_firmatario",
                    "update_firmatario",
                    "restore_firmatario",
                    "restore_any_firmatario",
                    "replicate_firmatario",
                    "reorder_firmatario",
                    "delete_firmatario",
                    "delete_any_firmatario",
                    "force_delete_firmatario",
                    "force_delete_any_firmatario",
                    "view_budget::category",
                    "view_any_budget::category",
                    "create_budget::category",
                    "update_budget::category",
                    "delete_budget::category",
                    "delete_any_budget::category",
                    "view_budget::subcategory",
                    "view_any_budget::subcategory",
                    "create_budget::subcategory",
                    "update_budget::subcategory",
                    "delete_budget::subcategory",
                    "delete_any_budget::subcategory",
                    "view_budget::item",
                    "view_any_budget::item",
                    "create_budget::item",
                    "update_budget::item",
                    "delete_budget::item",
                    "delete_any_budget::item",
                    "view_corso",
                    "view_any_corso",
                    "create_corso",
                    "update_corso",
                    "delete_corso",
                    "delete_any_corso",
                    "view_candidature",
                    "view_any_candidature",
                    "create_candidature",
                    "update_candidature",
                    "delete_candidature"
                ]
            },
            {
                "name": "utente",
                "guard_name": "web",
                "permissions": [
                    "page_UserDashboard",
                    "page_Anagrafica",
                    "page_Calendario"
                ]
            },
            {
                "name": "Segreteria organi",
                "guard_name": "web",
                "permissions": [
                    "page_UserDashboard",
                    "page_Anagrafica",
                    "page_CreateAnagrafica",
                    "page_Calendario",
                    "page_GestioneContatti",
                    "page_GestioneContratti",
                    "widget_CalendarWidget",
                    "widget_ContractSignersWidget",
                    "widget_ContrattiRecenti",
                    "view_firmatario",
                    "view_any_firmatario",
                    "create_firmatario",
                    "update_firmatario",
                    "view_user",
                    "view_any_user",
                    "view_corso",
                    "view_any_corso",
                    "create_corso",
                    "update_corso",
                    "delete_corso",
                    "delete_any_corso",
                    "view_candidature",
                    "view_any_candidature",
                    "create_candidature",
                    "update_candidature",
                    "delete_candidature"
                ]
            },
            {
                "name": "manager_didattico",
                "guard_name": "web",
                "permissions": [
                    "page_UserDashboard",
                    "page_Anagrafica",
                    "page_CreateAnagrafica",
                    "page_Calendario",
                    "page_GestioneCategorieCorsi",
                    "page_GestioneCorsi",
                    "widget_CalendarWidget",
                    "widget_AnagraficaCompletionChart",
                    "widget_AnagraficaRegistrationChart",
                    "widget_AnagraficaStatsOverview",
                    "view_user",
                    "view_any_user",
                    "create_user",
                    "update_user",
                    "restore_user",
                    "restore_any_user",
                    "replicate_user",
                    "reorder_user",
                    "delete_user",
                    "delete_any_user",
                    "force_delete_user",
                    "force_delete_any_user",
                    "view_corso",
                    "view_any_corso",
                    "create_corso",
                    "update_corso",
                    "delete_corso",
                    "delete_any_corso",
                    "view_candidature",
                    "view_any_candidature",
                    "create_candidature",
                    "update_candidature",
                    "delete_candidature"
                ]
            }
        ]';

        $directPermissions = collect();

        foreach (json_decode($rolesWithPermissions, true) as $item) {
            $role = Role::firstOrCreate([
                'name' => $item['name'],
                'guard_name' => $item['guard_name'],
            ]);

            $permissions = collect($item['permissions'])
                ->map(fn ($permission) => Permission::firstOrCreate([
                    'name' => $permission,
                    'guard_name' => $item['guard_name'],
                ]));

            $role->syncPermissions($permissions);

            $directPermissions = $directPermissions->merge($permissions);
        }

        // $this->command->info('Shield Seeding Completed.');
    }
}
