<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        // Creo l'utente amministrativo
        $user = User::firstOrCreate(
            ['email' => 'amministrativo@iul.it'],
            [
                'name' => 'Utente Amministrativo',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]
        );

        // Assegno il ruolo Amministrativo
        $user->assignRole('Amministrativo');
    }
} 