<!-- Panoramica -->
<div class="bg-slate-50 p-4 rounded-lg mb-8 text-gray-600 shadow-xl">
  Il sistema di gestione delle anagrafiche è progettato per gestire i dati personali, 
  fiscali e previdenziali degli utenti del sistema IULConnect. Il sistema supporta 
  sia la creazione completa che parziale delle anagrafiche, con funzionalità di 
  validazione avanzate.
</div>

<!-- Tipologie di Utenti -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Tipologie di Utenti</h2>
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h3 class="text-xl font-semibold mb-4 text-slate-600">Personale Docente</h3>
    <p class="text-gray-600">
      Comprende tutti i docenti dell'università, sia strutturati che a contratto. 
    </p>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h3 class="text-xl font-semibold mb-4 text-slate-600">
      Personale Tecnico Amministrativo
    </h3>
    <p class="text-gray-600">
      Include tutto il personale amministrativo e tecnico dell'università.
    </p>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h3 class="text-xl font-semibold mb-4 text-slate-600">
      Collaboratori
    </h3>
    <p class="text-gray-600">
      Categoria che include tutti i professionisti esterni che collaborano con 
      l'università.
    </p>
  </div>
</div>

<!-- Dati Principali (Obbligatori) -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Dati Principali (Obbligatori)</h2>
<div class="bg-yellow-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-yellow-600/40">
  Questi dati rappresentano le informazioni base necessarie per identificare 
  univocamente un utente nel sistema:
</div>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Nome e Cognome</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Vengono registrati separatamente per permettere una corretta generazione del codice fiscale</li>
      <li>Una migliore organizzazione delle anagrafiche</li>
      <li>Non sono ammessi caratteri speciali o numeri</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Telefono</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Viene registrato in formato internazionale (+39 per l'Italia)</li>
      <li>Viene validato per assicurare che sia un numero realmente esistente</li>
      <li>È possibile inserire sia numeri fissi che mobili</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Email</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Rappresenta l'identificativo univoco principale nel sistema</li>
      <li>Viene utilizzata per tutte le comunicazioni ufficiali e per l'accesso al sistema</li>
      <li>La sua unicità viene garantita anche in caso di cancellazione dell'anagrafica (soft delete)</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Tipologia Utente</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Determina il tipo di utente e influenza i campi obbligatori</li>
      <li>La scelta della tipologia è fondamentale per il corretto funzionamento del workflow successivo</li>
    </ul>
  </div>
</div>

<!-- Dati Personali -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Dati Personali</h2>
<div class="bg-green-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-green-600/40">
  Questa sezione raccoglie tutte le informazioni anagrafiche necessarie per 
  l'identificazione ufficiale della persona:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Genere</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Viene utilizzato sia per scopi statistici che per la corretta generazione del codice fiscale</li>
      <li>Le opzioni disponibili sono M (Maschio) e F (Femmina), in linea con le specifiche dell'Agenzia delle Entrate</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Data di nascita</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Utilizzata per la generazione del codice fiscale e per verifiche amministrative</li>
      <li>Il sistema accetta solo date valide e non future</li>
      <li>Controllo sull'età minima richiesta per le collaborazioni (18 anni)</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Codice Fiscale</h4>
    <p class="mb-3 text-gray-600">
      Elemento fondamentale per l'identificazione fiscale. Il sistema implementa:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Verifica della lunghezza (16 caratteri alfanumerici)</li>
      <li>Controllo della corrispondenza con i dati anagrafici</li>
      <li>Validazione dell'algoritmo di calcolo</li>
      <li>Verifica dell'unicità nel sistema</li>
    </ul>
    <p class="mt-3 text-gray-600">
      Il codice viene generato automaticamente dai dati inseriti e confrontato 
      con quello fornito dall'utente per garantire la correttezza.
    </p>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Luogo di nascita</h4>
    <p class="mb-3 text-gray-600">
      Comprende tre campi correlati:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li><span class="font-semibold">Città di nascita</span>: selezionabile da un database aggiornato dei comuni italiani</li>
      <li><span class="font-semibold">Provincia di nascita</span>: viene compilata automaticamente in base alla città</li>
      <li><span class="font-semibold">Regione di nascita</span>: viene compilata automaticamente in base alla provincia</li>
    </ul>
  </div>
</div>

<!-- Indirizzo di Residenza -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Indirizzo di Residenza</h2>
<div class="bg-purple-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-purple-600/40">
  La gestione degli indirizzi è integrata con servizi di geocoding per garantire 
  precisione e standardizzazione:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Indirizzo</h4>
    <p class="mb-3 text-gray-600">Utilizza l'API Google Places per:</p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Autocompletamento durante la digitazione</li>
      <li>Standardizzazione del formato</li>
      <li>Verifica dell'esistenza effettiva dell'indirizzo</li>
      <li>Geocodifica per future funzionalità di mappatura</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Numero Civico</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Viene gestito separatamente dall'indirizzo</li>
      <li>Supporta formati standard (es. "12") e complessi (es. "12/A")</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">CAP</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Codice di avviamento postale a 5 cifre</li>
      <li>Validato contro un database aggiornato dei CAP italiani</li>
      <li>Verifica la corrispondenza con la città indicata</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">
      Città e Provincia di Residenza
    </h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Gestite con la stessa logica del luogo di nascita</li>
      <li>Validazioni per garantire la coerenza con il CAP inserito</li>
    </ul>
  </div>
</div>

<!-- Dati Fiscali e Previdenziali -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Dati Fiscali e Previdenziali</h2>
<div class="bg-orange-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-orange-600/40">
  Questa sezione gestisce tutte le informazioni necessarie per il corretto 
  inquadramento fiscale e previdenziale:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Tipologia di lavoro</h4>
    <p class="mb-3 text-gray-600">
      Il sistema supporta tre diverse tipologie:
    </p>
    <div class="space-y-4">
      <div class="bg-gray-50 p-4 rounded-lg">
        <h5 class="font-semibold text-gray-700 mb-2">
          1. Lavoro autonomo professionale abituale
        </h5>
        <ul class="list-disc pl-5 text-gray-600">
          <li>Richiede obbligatoriamente la partita IVA</li>
          <li>Gestisce le informazioni dell'albo professionale</li>
          <li>Verifica il regime fiscale applicabile</li>
        </ul>
      </div>
      <div class="bg-gray-50 p-4 rounded-lg">
        <h5 class="font-semibold text-gray-700 mb-2">
          2. Contribuente nel nuovo regime fiscale di vantaggio
        </h5>
        <ul class="list-disc pl-5 text-gray-600">
          <li>Verifica i requisiti per il regime agevolato</li>
          <li>Gestisce le limitazioni specifiche del regime</li>
          <li>Traccia il periodo di applicazione del regime</li>
        </ul>
      </div>
      <div class="bg-gray-50 p-4 rounded-lg">
        <h5 class="font-semibold text-gray-700 mb-2">
          3. Lavoro autonomo occasionale
        </h5>
        <ul class="list-disc pl-5 text-gray-600">
          <li>Monitora il limite di reddito annuale</li>
          <li>Gestisce le ritenute d'acconto</li>
          <li>Traccia la progressione verso il limite per la partita IVA</li>
        </ul>
      </div>
    </div>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Partita IVA</h4>
    <p class="mb-3 text-gray-600">
      Per le partite IVA il sistema implementa:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Validazione del formato (11 cifre per l'Italia)</li>
      <li>Verifica in tempo reale tramite sistema VIES per partite IVA europee</li>
      <li>Controllo dello stato di attività</li>
      <li>Monitoraggio delle variazioni</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Albo Professionale</h4>
    <p class="mb-3 text-gray-600">
      Quando applicabile, gestisce:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Nome dell'albo</li>
      <li>Numero di iscrizione</li>
      <li>Data di iscrizione</li>
      <li>Verifica della validità dell'iscrizione</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Gestione Dipendenti PA</h4>
    <p class="mb-3 text-gray-600">
      Per i dipendenti pubblici, il sistema richiede e gestisce:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Denominazione completa dell'ente di appartenenza</li>
      <li>Numero del provvedimento di autorizzazione</li>
      <li>Data di rilascio dell'autorizzazione</li>
      <li>Periodo di validità</li>
      <li>Eventuali limitazioni specifiche</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Pensionati</h4>
    <p class="mb-3 text-gray-600">
      Per i titolari di pensione diretta, il sistema gestisce:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Tipo di pensione</li>
      <li>Ente erogatore</li>
      <li>Eventuali limitazioni di cumulo</li>
      <li>Gestione delle aliquote specifiche</li>
    </ul>
  </div>
</div>

<!-- Dati Pagamento -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Dati Pagamento</h2>
<div class="bg-red-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-red-600/40">
  La gestione dei dati di pagamento è cruciale per il corretto processo amministrativo:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">IBAN</h4>
    <p class="mb-3 text-gray-600">
      Il sistema implementa:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Validazione del formato secondo gli standard internazionali</li>
      <li>Verifica della corrispondenza con il paese di emissione</li>
      <li>Controllo dei caratteri di controllo</li>
      <li>Verifica della tipologia di conto (no conti risparmio)</li>
    </ul>
    <div class="mt-4 p-4 bg-slate-50 rounded-lg text-gray-600">
      Il sistema richiede inoltre una dichiarazione esplicita che il conto 
      sia intestato o cointestato al beneficiario.
    </div>
  </div>
</div>

<!-- Validazioni -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Validazioni</h2>
<!-- Codice Fiscale -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Codice Fiscale</h2>
<div class="bg-indigo-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-indigo-600/40">
  Il sistema implementa un processo di validazione completo del codice fiscale:
</div>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Validazione Strutturale</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Verifica della lunghezza (16 caratteri)</li>
      <li>Controllo del formato (6 lettere + 2 numeri + 1 lettera + 2 numeri + 1 lettera + 3 numeri + 1 lettera)</li>
      <li>Validazione dei caratteri ammessi</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Verifica di Corrispondenza</h4>
    <p class="mb-3 text-gray-600">
      Il sistema genera automaticamente il codice fiscale utilizzando:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Nome (con gestione dei nomi composti)</li>
      <li>Cognome (con gestione dei cognomi composti)</li>
      <li>Data di nascita (con conversione nel formato richiesto)</li>
      <li>Luogo di nascita (con gestione dei comuni soppressi)</li>
      <li>Genere (per il corretto calcolo del giorno di nascita)</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Controllo di Unicità</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Verifica dell'unicità nel database attivo</li>
      <li>Controllo anche sui record cancellati (soft delete)</li>
      <li>Gestione dei casi di omocodia</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Gestione Casi Speciali</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Supporto per codici fiscali provvisori</li>
      <li>Gestione dei codici fiscali stranieri</li>
      <li>Trattamento dei casi di omocodia</li>
    </ul>
  </div>
</div>

<!-- Partita IVA -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Partita IVA</h2>
<div class="bg-pink-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-pink-600/40">
  La validazione delle partite IVA include diversi livelli di controllo:
</div>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">
      Validazione Formato Nazionale
    </h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Verifica della lunghezza (11 cifre per l'Italia)</li>
      <li>Controllo della validità matematica</li>
      <li>Verifica della provincia di emissione</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">
      Validazione Europea (VIES)
    </h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Controllo in tempo reale tramite servizio VIES</li>
      <li>Verifica della validità</li>
      <li>Recupero dei dati aziendali associati</li>
      <li>Gestione degli errori di connessione</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Feedback all'Utente</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Indicazione visiva dello stato della verifica</li>
      <li>Messaggi di errore dettagliati</li>
      <li>Suggerimenti per la correzione</li>
    </ul>
  </div>
</div>

<!-- Email -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Email</h2>
<div class="bg-teal-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-teal-600/40">
  La gestione delle email include diverse verifiche per garantire l'unicità e 
  la validità degli indirizzi:
</div>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Validazione Formato</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Controllo della sintassi</li>
      <li>Verifica del dominio</li>
      <li>Controllo dei caratteri speciali</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Gestione Unicità</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Verifica nel database attivo</li>
      <li>Controllo sui record cancellati</li>
      <li>Procedura di ripristino per email duplicate</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Soft Delete</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Conservazione dei record cancellati</li>
      <li>Possibilità di ripristino</li>
      <li>Gestione delle collisioni in caso di ripristino</li>
    </ul>
  </div>
</div>

<!-- IBAN -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">IBAN</h2>
<div class="bg-amber-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-amber-600/40">
  La validazione IBAN implementa controlli approfonditi per garantire la correttezza 
  dei dati bancari:
</div>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Validazione Formato</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Controllo lunghezza per paese</li>
      <li>Verifica caratteri ammessi</li>
      <li>Calcolo checksum</li>
    </ul>
  </div>
  <div class="bg-slate-50 p-6 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Verifiche Aggiuntive</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Controllo paese di emissione</li>
      <li>Verifica della banca emittente</li>
      <li>Controllo del tipo di conto</li>
    </ul>
  </div>
</div>

<!-- Funzionalità Speciali -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Funzionalità Speciali</h2>

<!-- Invito Utente -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Invito Utente</h2>
<div class="bg-indigo-50 p-4 rounded-lg mb-6 text-gray-600">
  Il processo di invito utente è gestito in modo sicuro e tracciabile:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Email</h4>
    <p class="mb-3 text-gray-600">
      L'invito viene inviato tramite email con:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Link univoco di attivazione</li>
      <li>Scadenza automatica dopo 7 giorni</li>
      <li>Possibilità di reinvio</li>
      <li>Tracciamento dello stato (inviato, aperto, completato)</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Gestione Soft Delete</h4>
    <p class="mb-3 text-gray-600">
      Il sistema implementa il soft delete per:
    </p>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Preservare lo storico delle anagrafiche</li>
      <li>Permettere il ripristino in caso di cancellazione accidentale</li>
      <li>Mantenere l'integrità referenziale</li>
    </ul>
  </div>
</div>

<!-- Autocompletamento -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Autocompletamento</h2>
<div class="bg-pink-50 p-4 rounded-lg mb-6 text-gray-600 shadow-xl shadow-pink-600/40">
  Il sistema implementa funzionalità di autocompletamento avanzate:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Codice Fiscale</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Calcolo automatico dai dati anagrafici</li>
      <li>Verifica della correttezza formale</li>
      <li>Controllo di coerenza con i dati inseriti</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Partita IVA</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Suggerimento basato sul codice fiscale per persone fisiche</li>
      <li>Verifica in tempo reale della validità</li>
      <li>Controllo dello stato di attività</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Email</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Suggerimento domini comuni</li>
      <li>Correzione automatica errori comuni</li>
      <li>Verifica formato e sintassi</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">IBAN</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Formattazione automatica durante la digitazione</li>
      <li>Validazione in tempo reale</li>
      <li>Identificazione automatica della banca</li>
    </ul>
  </div>
</div>

<!-- Workflow -->
<h2 class="text-2xl font-bold mb-6 text-slate-800 border-b-2 border-slate-200 pb-2">Workflow</h2>
<div class="bg-teal-50 p-4 rounded-lg mb-6 text-gray-600">
  Il processo di gestione anagrafica segue un workflow strutturato:
</div>
<div class="space-y-6 mb-8">
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Creazione</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Inserimento dati principali</li>
      <li>Validazione in tempo reale</li>
      <li>Salvataggio temporaneo</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Verifica</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Controllo completezza dati</li>
      <li>Validazione incrociata</li>
      <li>Segnalazione incongruenze</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Approvazione</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Revisione da parte dell'amministratore</li>
      <li>Gestione modifiche richieste</li>
      <li>Notifiche automatiche</li>
    </ul>
  </div>
  <div class="bg-slate-50 py-2 px-4 rounded-lg shadow-md">
    <h4 class="text-lg font-semibold mb-3 text-slate-600">Attivazione</h4>
    <ul class="list-disc pl-5 text-gray-600">
      <li>Generazione credenziali</li>
      <li>Invio email di benvenuto</li>
      <li>Attivazione servizi</li>
    </ul>
  </div>
</div>
