<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header img {
            max-width: 200px;
            height: auto;
        }
        .content {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 5px;
        }
        .details {
            background-color: #f5f5f5;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .candidates-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .candidates-table th, .candidates-table td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .candidates-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ url('assets/loghi/logo-iul2.png') }}" alt="Logo IUL">
        </div>
        
        <div class="content">
            <h2>Selezione Candidature Completata</h2>
            
            <p>La selezione delle candidature per il corso "{{ $propostaCorso->titolo }}" è stata completata.</p>
            
            <h3>Candidati Approvati:</h3>
            
            <table class="candidates-table">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Cognome</th>
                        <th>Email</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($approvedCandidates as $candidate)
                    <tr>
                        <td>{{ $candidate['nome'] }}</td>
                        <td>{{ $candidate['cognome'] }}</td>
                        <td>{{ $candidate['email'] }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <p><strong>Totale candidati approvati:</strong> {{ count($approvedCandidates) }}</p>
            
            <p>Cordiali saluti,<br>
            Università Telematica degli Studi IUL</p>
        </div>
        
        <div class="footer">
            <p>Questa email è stata inviata da Università Telematica degli Studi IUL</p>
            <p>Non rispondere a questa email. Per assistenza, contattare il supporto.</p>
        </div>
    </div>
</body>
</html> 