<?php

namespace App\Filament\Pages;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Page;
use Filament\Resources\Components\Card;
use Filament\Resources\Components\Section as FilamentSection;
use Filament\Resources\Form as FilamentForm;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table as FilamentTable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class GestioneContratti extends Page
{
    public function getFormSchema(): array 
    {
        return [
            // ... existing code ...
            
            Section::make('Dettagli Contratto')
                ->schema([
                    Select::make('secondo_firmatario')
                        ->label('Secondo Firmatario')
                        ->options([
                            'direttore' => 'Dott. Mario Rossi - Direttore Generale',
                            'presidente' => 'Prof. Massimiliano Bizzocchi - Presidente',
                            'rettore' => 'Prof. Carlo Tasso - Rettore'
                        ])
                        ->required()
                        ->default('direttore')
                        ->helperText('Seleziona chi deve firmare il contratto dopo il primo firmatario'),
                        
                    // ... rest of the form fields ...
                ])
        ];
    }
} 