<x-filament-panels::page>
    <div class="flex flex-col md:flex-row gap-8">
        <div class="w-full md:w-1/3">
            <h2 class="text-2xl font-bold mb-4">Utenti</h2>
            <div class="bg-white rounded-lg shadow">
                <livewire:supabase-users-table />
            </div>
        </div>
        <div class="w-full md:w-2/3">
            @if($selectedEmail)
                <h2 class="text-2xl font-bold mb-4">Messaggi per {{ $selectedEmail }}</h2>
                <div class="bg-white rounded-lg shadow p-4 max-h-[600px] overflow-y-auto">
                    @if($isLoading)
                        <div class="flex justify-center items-center h-32">
                            <x-filament::loading-indicator class="w-8 h-8" />
                        </div>
                    @else
                        @forelse ($messages as $message)
                            <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                                <p class="text-sm text-gray-500">{{ $message->created_at }}</p>
                                @if ($message->user_message)
                                    <p class="mt-2"><strong class="text-blue-600">Utente:</strong> {{ $message->user_message }}</p>
                                @endif
                                @if ($message->bot_response)
                                    <p class="mt-2"><strong class="text-green-600">Bot:</strong> {!! $message->bot_response !!}</p>
                                @endif
                            </div>
                        @empty
                            <p class="text-gray-500">Nessun messaggio trovato per questo utente.</p>
                        @endforelse
                    @endif
                </div>
            @else
                <div class="flex items-center justify-center h-full">
                    <p class="text-gray-500 text-lg">Seleziona un utente per visualizzare i messaggi.</p>
                </div>
            @endif
        </div>
    </div>
</x-filament-panels::page>