<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Incarico di Collaborazione Occasionale</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.6;
            color: #000;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 20px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
        }
        .content {
            margin: 20px 0;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            font-size: 10px;
            color: #666;
            padding: 10px;
            text-align: left;
        }
        .signatures {
            margin-top: 50px;
        }
        .signature-line {
            margin: 30px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logo-iul2.png'))) }}" class="logo" alt="Logo IUL">
    </div>

    <div class="content">
        <p>Firenze, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>
        
        <p>{{ $anagrafica->nome }} {{ $anagrafica->cognome }}<br>
        {{ $anagrafica->indirizzo_residenza }} {{ $anagrafica->numero_civico_residenza }}<br>
        {{ $anagrafica->cap_residenza }} {{ $anagrafica->citta_residenza }} ({{ $anagrafica->provincia_residenza }})</p>

        <div class="title">
            OGGETTO: Incarico di collaborazione occasionale
        </div>

        <p>Con riferimento al D.M. n. 5 del 2 dicembre 2005, con il quale è stata istituita l'Università Telematica degli Studi IUL, autorizzata ad istituire ed attivare corsi universitari a distanza (laurea e laurea specialistica, master di I e II livello, corsi di perfezionamento), con la presente si incarica la S.V. di svolgere {{ $contratto->oggetto_incarico ?? 'attività di collaborazione' }}.</p>

        <p>Qualora la S.V. dia la propria disponibilità ad accettare l'incarico di cui trattasi, è invitata a restituire una copia di questo documento firmata per accettazione.</p>

        <p>Il presente incarico ha durata dal {{ \Carbon\Carbon::parse($contratto->data_inizio)->format('d/m/Y') }} al {{ \Carbon\Carbon::parse($contratto->data_fine)->format('d/m/Y') }}.</p>

        <p>Per l'attività proposta in questa sede, l'Università Telematica degli Studi IUL, corrisponderà alla S.V. la somma complessiva di Euro {{ number_format($contratto->compenso, 2, ',', '.') }} al Lordo di IRPEF, di IVA e della quota di contributo previdenziale obbligatoriamente a carico del committente.</p>

        <p>Il pagamento di detto compenso sarà effettuato previa presentazione di notula in regola con le norme fiscali, mediante accreditamento su conto corrente postale oppure bancario.</p>

        <p>Qualora la S.V. sia dipendente di pubblica amministrazione per il quale è prevista l'autorizzazione allo svolgimento di attività extraistituzionale ai sensi dell'Art. 53 del DLGS 165 2001 si resta in attesa di copia della stessa.</p>

        <p>Si specifica inoltre che il presente incarico non rientra nell'ipotesi normativa di cui all'art. 2, comma 1, del D.lgs. 81/15, poiché le modalità di esecuzione sono concordate con questa Amministrazione e comunque non sono in alcun modo organizzate dal committente con riferimento ai tempi e al luogo di lavoro.</p>

        <p>Tutti i dati personali contenuti nel presente incarico saranno trattati da IUL nel rispetto della legislazione vigente ai sensi del Regolamento UE 2016/679 - Regolamento Generale per la Protezione dei Dati (GDPR) e del D.Lgs. 30 giugno 2003 n. 196 (Codice in materia di protezione dei dati personali).</p>

        <p>La IUL si impegna a rispettare la riservatezza delle informazioni fornite dal collaboratore, così come previsto ai sensi della normativa vigente: "tutti i dati conferiti saranno trattati solo per finalità connesse e strumentali alla gestione della collaborazione, nel rispetto delle disposizioni vigenti".</p>

        <p>Con i più cordiali saluti,</p>

        <div class="signatures">
            <div class="signature-line">
                <p>Il Direttore Generale<br>
                dell'Università Telematica degli Studi IUL<br>
                Dott. Massimiliano Bizzocchi</p>
                <p>____________________________</p>
            </div>

            <div class="signature-line">
                <p>Per accettazione</p>
                <p>____________________________</p>
            </div>
        </div>
    </div>

    <div class="footer">
        <p>50122 Firenze, Via M. Buonarroti 10 - cod. fis./p. iva 056665304489 - tel. +39 055 0380900 - www.iuline.it</p>
    </div>
</body>
</html> 