<?php

use Illuminate\Support\Facades\Route;
use App\Filament\Pages\Anagrafica;
use App\Http\Controllers\AnagraficaController;
use App\Http\Controllers\ContrattoController;
use App\Http\Controllers\PropostaCorsoController;
use App\Http\Controllers\CvDownloadController;

Route::redirect('/', '/admin');

Route::middleware(['auth'])->group(function () {
    Route::get('/admin/anagrafica/{id?}', Anagrafica::class)
        ->name('filament.pages.anagrafica')
        ->middleware(config('filament.middleware.base'));

    Route::get('/download-contratto/{id}', [ContrattoController::class, 'downloadPdf'])
        ->name('download.contratto.pdf');

    Route::get('/download-contratto-firmato/{id}', [ContrattoController::class, 'downloadContrattoFirmato'])
        ->name('download.contratto.firmato');

    Route::get('/nulla-osta/{anagrafica}', [App\Http\Controllers\NullaOstaController::class, 'download'])
        ->name('nulla-osta.download');

    Route::get('/proposta-corso/{propostaCorso}/pdf', [PropostaCorsoController::class, 'generatePdf'])
        ->name('proposta-corso.pdf');
});

Route::middleware(['auth', 'download.permission'])->group(function () {
    Route::get('/cv/download/{id}', [CvDownloadController::class, 'download'])->name('cv.download');
});

Route::get('/completa-anagrafica/{token}', [AnagraficaController::class, 'showCompleteForm'])
    ->name('complete.anagrafica');

Route::post('/completa-anagrafica/{token}', [AnagraficaController::class, 'saveCompleteForm'])
    ->name('save.complete.anagrafica');

Route::get('/candidature/complete/{token}', App\Livewire\CompleteCandidature::class)
    ->name('complete-candidature');

Route::get('/prova2', function() {
    return 'Deploy test successful - ' . date('Y-m-d H:i:s');
});