<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        Log::info('Scheduler started');

        // Backup giornaliero del database e dei file
        $schedule->command('backup:clean')->daily()->at('01:00');
        $schedule->command('backup:run')->daily()->at('01:30');
        
        // Monitor dello stato dei backup
        $schedule->command('backup:monitor')->daily()->at('02:00');

        // Controlla lo stato delle firme ogni minuto
        $schedule->job(new \App\Jobs\CheckYousignStatus())
            ->everyMinute()
            ->appendOutputTo(storage_path('logs/yousign-check.log'))
            ->before(function () {
                Log::info('CheckYousignStatus job scheduled');
            })
            ->after(function () {
                Log::info('CheckYousignStatus job completed scheduling');
            });

        Log::info('Scheduler completed');
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
} 