<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Models\Anagrafica as AnagraficaModel;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Illuminate\Support\Facades\Auth;

class Anagrafica extends Page 
{
    use HasPageShield;
    protected static ?string $navigationIcon = 'heroicon-o-document-text';
    protected static string $view = 'filament.pages.anagrafica';
    protected static ?int $navigationSort = 1;
    protected static ?string $navigationGroup = 'Anagrafica';
    public $anagraficaId;
    public $pageTitle = 'Aggiungi nuova anagrafica';

    public static function getNavigationLabel(): string
    {
        return Auth::user()?->hasRole('utente') ? 'La mia anagrafica' : 'Crea anagrafica';
    }

    protected function isNormalUser(): bool 
    {
        return Auth::check() && Auth::user()->hasRole('utente');
    }

    public function mount(Request $request)
    {
        if ($this->isNormalUser()) {
            // Se è un utente normale, recupera la sua anagrafica
            $anagrafica = AnagraficaModel::where('panel_email', Auth::user()->email)->first();
            
            // Se l'utente prova ad accedere a un'altra anagrafica, lo redirigo alla sua
            if ($request->has('id') && $request->input('id') != $anagrafica?->id) {
                $this->redirect(static::getUrl(['id' => $anagrafica?->id]));
                return;
            }

            if ($anagrafica) {
                $this->anagraficaId = $anagrafica->id;
                $this->pageTitle = "La mia anagrafica";
                
                // Reindirizza solo se l'id non è già presente nell'URL
                if (!$request->has('id')) {
                    $this->redirect(static::getUrl(['id' => $anagrafica->id]));
                }
            } else {
                // Se l'utente non ha un'anagrafica, mostra un errore
                abort(403, 'Non hai un\'anagrafica associata al tuo account.');
            }
        } else {
            // Per admin e staff
            $this->anagraficaId = $request->input('id');
            if ($this->anagraficaId) {
                $anagrafica = AnagraficaModel::find($this->anagraficaId);
                if ($anagrafica) {
                    $this->pageTitle = "Modifica anagrafica di {$anagrafica->nome} {$anagrafica->cognome}";
                } else {
                    $this->pageTitle = 'Modifica anagrafica';
                }
            }
        }
    }

    // protected function getHeaderActions(): array
    // {
    //     // Mostra il pulsante "Crea" solo per admin e staff
    //     if (!$this->isNormalUser()) {
    //         return [
    //             \Filament\Actions\Action::make('create')
    //                 ->label('Nuova Anagrafica')
    //                 ->url(fn () => static::getUrl())
    //                 ->icon('heroicon-o-plus')
    //         ];
    //     }
    //     return [];
    // }

    public static function getUrl(array $parameters = [], bool $isAbsolute = true, ?string $panel = null, ?Model $tenant = null): string
    {
        $user = Auth::user();
        if ($user && $user->hasRole('utente')) {
            // Se è un utente normale, recupera la sua anagrafica
            $anagrafica = AnagraficaModel::where('panel_email', $user->email)->first();
            if ($anagrafica) {
                $parameters['id'] = $anagrafica->id;
            }
        }
        return parent::getUrl($parameters, $isAbsolute, $panel, $tenant);
    }
    
    public function getTitle(): string
    {
        return $this->pageTitle;
    }
}