<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Models\Contratto as ContrattoModel;
use Filament\Forms\Form;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Section;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class CreateContratti extends Page
{
    use HasPageShield;

    protected static ?string $navigationGroup = 'Contratti';
    protected static ?string $navigationIcon = 'heroicon-o-document-plus';
    protected static ?string $navigationLabel = 'Crea Contratto';
    protected static ?string $title = 'Crea Nuovo Contratto';
    protected static string $view = 'filament.pages.create-contratti';
    public $contrattoId;

    public function mount(Request $request)
    {
        $this->contrattoId = $request->input('id');
    }
}