<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Livewire\Attributes\Url;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\DB;

class SupabaseConversations extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-left-right';
    protected static ?string $navigationLabel = 'IULia';
    protected static ?string $title = 'IULia';
    protected static string $view = 'filament.pages.supabase-conversations';

    #[Url]
    public ?string $selectedEmail = null;

    public $messages = [];
    public bool $isLoading = false;

    #[On('select-email')]
    public function selectEmail($email)
    {
        $this->isLoading = true;
        $this->selectedEmail = $email;
        $this->loadMessages();
        $this->isLoading = false;
    }

    public function loadMessages()
    {
        if ($this->selectedEmail) {
            $this->messages = DB::connection('supabase2')
                ->table('conversations')
                ->where('user_email', $this->selectedEmail)
                ->orderBy('created_at')
                ->get();
        }
    }

    public function getViewData(): array
    {
        $messages = [];
        if ($this->selectedEmail) {
            $messages = DB::connection('supabase2')
                ->table('conversations')
                ->where('user_email', $this->selectedEmail)
                ->orderBy('created_at')
                ->get();
        }

        return [
            'messages' => $messages,
        ];
    }

    public static function shouldRegisterNavigation(): bool
    {
        return false;
    }
}
