<?php

namespace App\Filament\Resources;

use App\Filament\Resources\BudgetSubcategoryResource\Pages;
use App\Models\BudgetSubcategory;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Grouping\Group;

class BudgetSubcategoryResource extends Resource
{
    protected static ?string $model = BudgetSubcategory::class;
    protected static ?string $navigationIcon = 'heroicon-o-currency-euro';
    protected static ?string $navigationGroup = 'Finanziario';
    protected static ?int $navigationSort = 2;
    protected static ?string $modelLabel = 'Contabilità Analitica';
    protected static ?string $pluralModelLabel = 'Contabilità Analitica';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Informazioni Contabilità Analitica')
                    ->description('Inserisci le informazioni della contabilità analitica')
                    ->schema([
                        Forms\Components\Select::make('budget_category_id')
                            ->relationship('category', 'name')
                            ->label('Macro Voce')
                            ->required()
                            ->preload()
                            ->searchable(),
                        Forms\Components\TextInput::make('name')
                            ->label('Nome')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('code')
                            ->label('Codice')
                            ->required()
                            ->maxLength(255)
                            ->unique(ignoreRecord: true),
                        Forms\Components\Toggle::make('is_active')
                            ->label('Attivo')
                            ->required()
                            ->default(true),
                        Forms\Components\Textarea::make('description')
                            ->label('Descrizione')
                            ->maxLength(65535)
                            ->columnSpanFull(),
                    ])
                    ->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultGroup('category.name')
            ->groups([
                Group::make('category.name')
                    ->label('Macro Voce')
                    ->collapsible(),
            ])
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Nome')
                    ->searchable(),
                Tables\Columns\TextColumn::make('code')
                    ->label('Codice')
                    ->searchable(),
                Tables\Columns\TextColumn::make('description')
                    ->label('Descrizione')
                    ->searchable()
                    ->limit(50),
                Tables\Columns\IconColumn::make('is_active')
                    ->label('Attivo')
                    ->boolean(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Data Creazione')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Ultima Modifica')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('budget_category_id')
                    ->relationship('category', 'name')
                    ->label('Macro Voce'),
                Tables\Filters\TernaryFilter::make('is_active')
                    ->label('Attivo')
                    ->default(true),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('Modifica'),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()
                        ->label('Elimina Selezionati'),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBudgetSubcategories::route('/'),
            'create' => Pages\CreateBudgetSubcategory::route('/create'),
            'edit' => Pages\EditBudgetSubcategory::route('/{record}/edit'),
        ];
    }
} 