<?php

namespace App\Filament\Resources\ContrattoTemplateResource\RelationManagers;

use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Traits\HasRoles;

class ContrattiRelationManager extends RelationManager implements HasShieldPermissions
{
    protected static string $relationship = 'contratti';

    protected static ?string $title = 'Contratti che usano questo template';

    protected static string $model = 'App\\Models\\Contratto';

    public static function getPermissionPrefixes(): array
    {
        return [
            'viewAny',
            'view',
            'create',
            'update',
            'delete',
            'deleteAny'
        ];
    }

    public static function canViewForRecord(Model $ownerRecord, string $pageClass): bool
    {
        $user = Auth::user();
        return $user && $user->hasRole(['ufficio legale', 'super_admin']);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                Tables\Columns\TextColumn::make('anagrafica.nome_completo')
                    ->label('Anagrafica')
                    ->searchable(['anagrafiche.nome', 'anagrafiche.cognome'])
                    ->sortable(),
                Tables\Columns\TextColumn::make('tipoContratto.nome')
                    ->label('Tipo Contratto')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('data_inizio')
                    ->label('Data Inizio')
                    ->date('d/m/Y')
                    ->sortable(),
                Tables\Columns\TextColumn::make('data_fine')
                    ->label('Data Fine')
                    ->date('d/m/Y')
                    ->sortable(),
                Tables\Columns\TextColumn::make('compenso')
                    ->label('Compenso')
                    ->money('EUR')
                    ->sortable(),
            ])
            ->actions([
                Tables\Actions\Action::make('edit')
                    ->label('Modifica')
                    ->url(fn ($record) => route('filament.admin.pages.create-contratti', ['id' => $record->id]))
                    ->openUrlInNewTab()
            ]);
    }
} 