<?php

namespace App\Http\Controllers;

use App\Models\Anagrafica;
use Illuminate\Http\Response;
use Barryvdh\DomPDF\Facade\Pdf;

class NullaOstaController extends Controller
{
    public function download(Anagrafica $anagrafica)
    {
        $pdf = Pdf::loadView('pdf.nulla-osta', [
            'anagrafica' => $anagrafica,
        ]);

        return $pdf->download('nulla-osta-' . $anagrafica->cognome . '-' . $anagrafica->nome . '.pdf');
    }
}
