<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Str;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;

class Candidature extends Model implements HasShieldPermissions
{
    protected $fillable = [
        'nome',
        'cognome',
        'email',
        'proposta_corso_id',
        'invitation_token',
        'cv_path',
        'is_complete',
        'privacy_accepted',
        'privacy_accepted_at',
        'is_approved',
        'approved_at',
    ];

    protected $casts = [
        'is_complete' => 'boolean',
        'privacy_accepted' => 'boolean',
        'privacy_accepted_at' => 'datetime',
        'is_approved' => 'boolean',
        'approved_at' => 'datetime',
    ];

    public function propostaCorso(): BelongsTo
    {
        return $this->belongsTo(PropostaCorso::class);
    }

    public function anagrafica(): BelongsTo
    {
        return $this->belongsTo(Anagrafica::class, 'email', 'email');
    }

    public function generateInvitationToken(): void
    {
        $this->invitation_token = Str::random(32);
        $this->save();
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view',
            'view_any',
            'create',
            'update',
            'delete',
            'delete_any'
        ];
    }
} 