<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Domicilio extends Model
{
    protected $table = 'domicili';

    protected $fillable = [
        'anagrafica_id',
        'indirizzo',
        'numero_civico',
        'cap',
        'citta',
        'provincia',
    ];

    public function anagrafica(): BelongsTo
    {
        return $this->belongsTo(Anagrafica::class);
    }
}
