<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('proposta_corsos', function (Blueprint $table) {
            $table->id();
            $table->string('titolo');
            $table->string('tipologia_percorso');
            $table->string('titolo_esteso');
            $table->integer('cfu');
            $table->string('modalita_erogazione');
            $table->string('anno_accademico');
            $table->string('direttore_corso');
            $table->string('coordinatore_corso');
            $table->text('obiettivi_finalita');
            $table->json('contenuti'); // Repeater per moduli
            $table->text('destinatari');
            $table->text('durata');
            $table->text('coerenza_metodologia');
            $table->text('modalita_conseguimento');
            $table->json('figure_professionali'); // Repeater per figure professionali
            $table->text('costo_iscrizione');
            $table->text('partner_scientifici')->nullable();
            $table->text('partner_organizzativi')->nullable();
            $table->enum('stato', ['bozza', 'inviata', 'approvata', 'rifiutata'])->default('bozza');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('proposta_corsos');
    }
};
