<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('corsi', function (Blueprint $table) {
            $table->string('presidente_cds')->nullable()->after('ssd');
            $table->text('titolo_accesso')->nullable()->after('presidente_cds');
            $table->decimal('costo', 8, 2)->after('titolo_accesso');
            $table->boolean('rateizzabile')->default(true)->after('costo');
        });
    }

    public function down(): void
    {
        Schema::table('corsi', function (Blueprint $table) {
            $table->dropColumn(['presidente_cds', 'titolo_accesso', 'costo', 'rateizzabile']);
        });
    }
};