<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->string('codice_fiscale')->nullable()->change();
            $table->date('data_nascita')->nullable()->change();
            $table->string('citta_nascita')->nullable()->change();
            $table->string('provincia_nascita', 2)->nullable()->change();
            $table->string('regione_nascita')->nullable()->change();
            $table->string('indirizzo_residenza')->nullable()->change();
            $table->string('numero_civico_residenza')->nullable()->change();
            $table->string('cap_residenza', 5)->nullable()->change();
            $table->string('citta_residenza')->nullable()->change();
            $table->string('provincia_residenza', 2)->nullable()->change();
        });
    }

    public function down()
    {
        Schema::table('anagrafiche', function (Blueprint $table) {
            $table->string('codice_fiscale')->nullable(false)->change();
            $table->date('data_nascita')->nullable(false)->change();
            $table->string('citta_nascita')->nullable(false)->change();
            $table->string('provincia_nascita', 2)->nullable(false)->change();
            $table->string('regione_nascita')->nullable(false)->change();
            $table->string('indirizzo_residenza')->nullable(false)->change();
            $table->string('numero_civico_residenza')->nullable(false)->change();
            $table->string('cap_residenza', 5)->nullable(false)->change();
            $table->string('citta_residenza')->nullable(false)->change();
            $table->string('provincia_residenza', 2)->nullable(false)->change();
        });
    }
};
