<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tipi_contratto', function (Blueprint $table) {
            $table->string('nome_breve')->after('nome');
            $table->string('colore')->after('descrizione')->default('secondary');
            $table->string('slug')->after('colore')->unique();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tipi_contratto', function (Blueprint $table) {
            $table->dropColumn(['nome_breve', 'colore', 'slug']);
        });
    }
};
