<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->decimal('costo_lordo_aziendale', 10, 2)->nullable()->after('compenso');
            $table->decimal('costo_lordo_dipendente', 10, 2)->nullable()->after('costo_lordo_aziendale');
            $table->decimal('costo_orario', 10, 2)->nullable()->after('costo_lordo_dipendente');
            $table->decimal('costo_giornaliero', 10, 2)->nullable()->after('costo_orario');
        });
    }

    public function down()
    {
        Schema::table('contratti', function (Blueprint $table) {
            $table->dropColumn([
                'costo_lordo_aziendale',
                'costo_lordo_dipendente',
                'costo_orario',
                'costo_giornaliero'
            ]);
        });
    }
}; 