<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('contratto_templates', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->text('contenuto');
            $table->boolean('is_default')->default(false);
            $table->json('placeholders')->nullable(); // Memorizza i placeholder disponibili
            $table->string('yousign_procedure_id')->nullable();
            $table->string('yousign_status')->nullable();
            $table->timestamp('signed_at')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('contratto_templates');
    }
}; 